# Copyright (C) Andrew Tridgell <tridge@samba.org>     2001
# script to show recent checkins in cvs

package history;

my $BASEDIR = "/var/local/bluefish_build";
my $TIMEZONE = "PST";
my $TIMEOFFSET = 0;

use strict qw{vars};
use util;
use POSIX;
use Data::Dumper;
use CGI::Base;
use CGI::Form;
use File::stat;

my $req = new CGI::Form;

my $HEADCOLOR = "#a0a0e0";
my $CVSWEB_BASE = "http://sourceforge.net/cvs/?group_id=11621";

my (%tree_base) = ('bluefish' => "bluefish",
		   'bluefish-gtk2' => "bluefish-gtk2"
		   );

my $unpacked_dir = "/home/ftp/pub/unpacked";

###############################################
# work out a URL so I can refer to myself in links
#my $mysite = $req->self_url;
#if ($mysite =~ /(.*)[?].*/) {
#    $mysite = $1;
#}
#if ($mysite =~ /http:\/\/.*\/(.*)/) {
#    $mysite = $1;
#}

my $mysite = "http://bluefish.mrball.net/";

################################################
# start CGI headers
sub cgi_headers() {
    print "Content-type: text/html\r\n";

    util::cgi_gzip();

    print '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> 
<html>
<head><title>recent checkins</title></head>
<body bgcolor="white" text="#000000" link="#0000EE" vlink="#551A8B" alink="#FF0000">
';

}

################################################
# end CGI
sub cgi_footers() {
    print "</body>";
    print "</html>\n";
}

################################################
# print an error on fatal errors
sub fatal($) {
    my $msg=shift;
    print "ERROR: $msg<br>\n";
    cgi_footers();
    exit(0);
}


###############################################
# pretty up a cvs diff -u
sub cvs_pretty($)
{
    my $diff = shift;
    my $ret = "";
    my @lines = split(/$/m, $diff);

    my (%colors) = (
		    '^diff.*' => 'red',
		    '^=.*' => 'blue',
		    '^Index:.*' => 'blue',
		    '^\-.*' => '#a00000',
		    '^\+.*' => '#00a000'
		    );

    for (my $i=0; $i <= $#lines; $i++) {
	my $line = $lines[$i];

	for my $r (keys %colors) {
	    if ($line =~ /$r/m) {
		$line = "<font color=\"$colors{$r}\">$line</font>";
		last;
	    }
	}
	$ret .= $line;
    }
    return $ret;
}

sub cvsweb_paths($$)
{
    my $tree = shift;
    my $paths = shift;
    my $ret = "";
    while ($paths =~ /\s*([^\s]+)(.*)/) {
	$ret .= "<a href=\"$CVSWEB_BASE/$tree_base{$tree}/$1\">$1</a> ";
	$paths = $2;
    }
    
    return $ret;
}

#############################################
# show one row of history table
sub history_row($$)
{
    my $entry = shift;
    my $tree = shift;
    my $msg = util::cgi_escape($entry->{MESSAGE});
    my $t = POSIX::asctime(POSIX::gmtime($entry->{DATE}));
    my $age = util::dhm_time(time()-$entry->{DATE});

    $msg =~ s/\n/<br>\n/g;
    $msg =~ s/<br>\n<br>\n/<p>\n/g;
    $t =~ s/\ /&nbsp;/g;

    print "
<table border=3>
<tr><td valign=top>
<b>$t</b><br>
$age ago<br>
<b><a href=$mysite?function=diff&tree=$tree&date=$entry->{DATE}&author=$entry->{AUTHOR}>show diffs</a></b><br>
<a href=$mysite?function=text_diff&tree=$tree&date=$entry->{DATE}&author=$entry->{AUTHOR}>download diffs</a><br>
</td>
<td>$msg</td>
</tr>
</table>
<table>
<tr><td><b>Author:</b></td><td>$entry->{AUTHOR}</td></tr>
<tr valign=top><td><b>Modified:</b></td><td>";
print cvsweb_paths($tree, $entry->{FILES});
print "</td></tr>
<tr valign=top><td><b>Added:</b></td><td>";
print cvsweb_paths($tree, $entry->{ADDED});
print "</td></tr>
<tr valign=top><td><b>Removed:</b></td><td>";
print cvsweb_paths($tree, $entry->{REMOVED});
print "</td></tr>
</table>
\n";
}


###############################################
# show recent cvs entries
sub cvs_diff($$$$)
{
    my $author = shift;
    my $date = shift;
    my $tree = shift;
    my $text_html = shift;
    my $cmd;

    util::InArray($tree, [keys %tree_base]) || fatal("unknown tree");

    my $log = util::LoadStructure("history.$tree");

    chdir("$unpacked_dir/$tree") || fatal("no tree $unpacked_dir/$tree available");

    for (my $i=0; $i <= $#{$log}; $i++) {
	my $entry = $log->[$i];
	if ($author eq $entry->{AUTHOR} &&
	    $date == $entry->{DATE}) {
	    my $t1;
	    my $t2;

	    chomp($t1 = POSIX::ctime($date-60+($TIMEOFFSET*60*60)));
	    chomp($t2 = POSIX::ctime($date+60+($TIMEOFFSET*60*60)));

	    print "<h2>CVS Diff in $tree for $t1</h2>\n";

	    print "<table border=0><tr>\n";
	    history_row($entry, $tree);
	    print "</tr></TABLE>\n";

	    if (! ($entry->{TAG} eq "") && !$entry->{REVISIONS}) {
		print '
<br>
<b>sorry, cvs diff on branches not currently possible due to a limitation 
in cvs</b>
<br>';
	    }

	    $ENV{'CVS_PASSFILE'} = "$BASEDIR/.cvspass";

	    if ($entry->{REVISIONS}) {
		    for my $f (keys %{$entry->{REVISIONS}}) {
			    my $cmd = "cvs diff -b -u -r $entry->{REVISIONS}->{$f}->{REV1} -r $entry->{REVISIONS}->{$f}->{REV2} $f";
			    print "<!-- $cmd --!>\n";
			    my $diff = `$cmd 2> /dev/null`;
			    
			    if ($text_html eq "html") { 
				$diff = util::cgi_escape($diff);
				$diff = cvs_pretty($diff);
			    }
			    print "<pre>$diff</pre>\n";
		    }
	    } else {
		    my $cmd = "cvs diff -b -u -D \"$t1 $TIMEZONE\" -D \"$t2 $TIMEZONE\" $entry->{FILES}";
		    print "<!-- $cmd --!>\n";
		    my $diff = `$cmd 2> /dev/null`;

		    if ($text_html eq "html") { 
			$diff = util::cgi_escape($diff);
				$diff = cvs_pretty($diff);
		    }
		    
		    print "<pre>$diff</pre>\n";
	    }

	    return;
	}
    }    
}


###############################################
# show recent cvs entries
sub cvs_history($)
{
    my $tree = shift;
    my (%authors) = ('ALL');
    my $author;

    util::InArray($tree, [keys %tree_base]) || fatal("unknown tree");

    my $log = util::LoadStructure("history.$tree");

    for (my $i=$#{$log}; $i >= 0; $i--) {
	$authors{$log->[$i]->{AUTHOR}} = 1;
    }

    print $req->startform("GET");
    print "Select Author: ";
    print $req->popup_menu("author", [sort keys %authors]);
    print $req->submit('sub_function', 'Refresh');
    print $req->hidden('tree', $tree);
    print $req->hidden('function', 'Recent Checkins');
    print $req->endform();

    print "<h2>Recent checkins for $tree</h2>\n";
    
    print "
";

    $author = $req->param("author");

    for (my $i=$#{$log}; $i >= 0; $i--) {
	my $entry = $log->[$i];
	if (! $author ||
	    ($author eq "ALL") || 
	    ($author eq $entry->{AUTHOR})) {
	    history_row($entry, $tree);
	}
    }
    print '
';
}


#cvs_diff($req->param('author'), $req->param('date'), $req->param('tree'));
#cvs_history("trinity");


1;
